/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.ui.opengl;

import frc.emul.vectrex.ui.opengl.GLUtils;
import frc.emul.vectrex.ui.opengl.JoglTexture;
import frc.emul.vectrex.ui.opengl.shader.ShaderNotSupportedException;
import javax.media.opengl.GL;

public class JoglFBO {
    private boolean validated;
    private int fbo;

    public void release(GL gL) {
        if (this.fbo != 0) {
            gL.glDeleteFramebuffersEXT(1, new int[]{this.fbo}, 0);
            this.validated = false;
            this.fbo = 0;
        }
    }

    public String validate(GL gL) {
        if (!this.validated) {
            int n = gL.glCheckFramebufferStatusEXT(36160);
            if (n != 36053) {
                return "Incorrect Frame Buffer status (" + GLUtils.getNonNullConstantName(n) + ")";
            }
            this.validated = true;
        }
        return null;
    }

    public void bind(GL gL) {
        this.allocate(gL);
        gL.glBindFramebufferEXT(36160, this.fbo);
    }

    public void unbind(GL gL) {
        gL.glBindFramebufferEXT(36160, 0);
    }

    public void attachColorBuffer(GL gL, JoglTexture joglTexture) {
        this.attach(gL, 36064, joglTexture.getTexture(gL));
    }

    public void attachDepthBuffer(GL gL, JoglTexture joglTexture) {
        this.attach(gL, 36096, joglTexture.getTexture(gL));
    }

    public void attachStencilBuffer(GL gL, JoglTexture joglTexture) {
        this.attach(gL, 36128, joglTexture.getTexture(gL));
    }

    public void attachColorBuffer(GL gL, int n) {
        this.attach(gL, 36064, n);
    }

    public void attachDepthBuffer(GL gL, int n) {
        this.attach(gL, 36096, n);
    }

    public void attachStencilBuffer(GL gL, int n) {
        this.attach(gL, 36128, n);
    }

    public void attach(GL gL, int n, int n2) {
        this.validated = false;
        gL.glFramebufferTexture2DEXT(36160, n, 3553, n2, 0);
    }

    public static void checkFrameBufferSupport(GL gL) throws ShaderNotSupportedException {
        String string = "OpenGL FrameBuffer Objects not available";
        GLUtils.checkExtension(gL, "GL_EXT_framebuffer_object", string);
    }

    private void allocate(GL gL) {
        if (this.fbo == 0) {
            int[] nArray = new int[1];
            gL.glGenFramebuffersEXT(1, nArray, 0);
            this.fbo = nArray[0];
        }
    }
}

